//=============================================================================
// ScreenColorFilter.js
//=============================================================================

/*:
 * @plugindesc Apply saturation and brightness filter to the entire screen.
 * 
 * @param Saturation
 * @desc Saturation level to apply to the screen (-100 to 100)
 * @default 0
 * 
 * @param Brightness
 * @desc Brightness level to apply to the screen (-255 to 255)
 * @default 0
 * 
 * @help ScreenColorFilter.js
 * 
 * This plugin allows you to apply saturation and brightness filter
 * to the entire screen.
 * 
 * To adjust the saturation and brightness levels, set the parameters
 * 'Saturation' and 'Brightness' in the plugin manager.
 * 
 */

(function() {
    var parameters = PluginManager.parameters('ScreenColorFilter');
    var saturation = parseInt(parameters['Saturation']);
    var brightness = parseInt(parameters['Brightness']);

    var _Scene_Base_create = Scene_Base.prototype.create;
    Scene_Base.prototype.create = function() {
        _Scene_Base_create.call(this);
        this.createColorFilter();
    };

    Scene_Base.prototype.createColorFilter = function() {
        var saturationFilter = new PIXI.filters.SaturationFilter();
        saturationFilter.saturation = saturation / 100;
        this.filters = [saturationFilter];

        var brightnessFilter = new PIXI.filters.BrightnessFilter();
        brightnessFilter.brightness = brightness / 255;
        this.filters.push(brightnessFilter);

        this._colorFilter = new PIXI.Container();
        this.addChild(this._colorFilter);
    };
})();